#include <iostream>
#include <vector>

using namespace std;

vector<int> calculateXOR(const vector<int>& P, const vector<int>& Q) {
    vector<int> result;
    for (size_t i = 0; i < P.size(); ++i) {
        result.push_back(P[i] ^ Q[i]);
    }
    return result;
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        int N;
        cin >> N;

        vector<int> P(N + 1);
        for (int i = 0; i <= N; ++i) {
            cin >> P[i];
        }

        vector<int> Q(N + 1, 0);

        if (N % 2 == 1) {
            for (int i = 0; i <= N; ++i) {
                Q[i] = P[i];
            }
        } else {
            Q[0] = P[0] ^ P[1];

            for (int i = 1; i < N; ++i) {
                Q[i] = P[i - 1] ^ P[i + 1];
            }

            Q[N] = P[N - 1] ^ P[0];
        }

        vector<int> result = calculateXOR(P, Q);

        cout << result[0];
        for (int i = 1; i < result.size(); ++i) {
            cout << " " << result[i];
        }
        cout << endl;
    }

    return 0;
}